import QtQuick 2.15
import QtQuick.Controls 2.15

Row {
    id: _root
    height: 28

    property string title: ""
    property string comment : ""
    property alias model: comboItem.model
    property alias currentIndex: comboItem.currentIndex

    signal activated(int index)

    Text {
        width: 100
        height: parent.height
        font.pointSize: 14
        text: parent.title
        verticalAlignment: Text.AlignVCenter
    }
    Rectangle {
        width: 148+48
        height: parent.height
        color: "white"
        border.color: "grey"
        ComboBox {
            id: comboItem
            anchors.fill: parent
            anchors.margins: 1
            font.pointSize: 12
//          currentIndex: 0
            onActivated: {
                console.log(displayText)
                console.log(index)
                _root.activated(index)
            }
        }
    }
    Text {
        width: contentWidth
        height: parent.height
        font.pointSize: 14
        text: parent.comment
        verticalAlignment: Text.AlignVCenter
    }
}
